function T = dynamic_g1_tt(T, y, x, params, steady_state, it_)
% function T = dynamic_g1_tt(T, y, x, params, steady_state, it_)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double  vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double  vector of endogenous variables in the order stored
%                                                    in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double  matrix of exogenous variables (in declaration order)
%                                                    for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double  vector of steady state values
%   params        [M_.param_nbr by 1]        double  vector of parameter values in declaration order
%   it_           scalar                     double  time period for exogenous variables for which
%                                                    to evaluate the model
%
% Output:
%   T           [#temp variables by 1]       double  vector of temporary terms
%

assert(length(T) >= 236);

T = World_Economy_Cartel_Fracking_IRF.dynamic_resid_tt(T, y, x, params, steady_state, it_);

T(112) = exp(y(26))*exp(y(29))*T(91);
T(113) = T(35)+T(34)+T(33)*y(22)*(-(exp(y(26))*T(24)));
T(114) = (-(T(23)*exp(y(36))*exp(y(101))));
T(115) = (-(exp(y(6))*exp((-y(49)))*exp(y(10))));
T(116) = T(40)+params(25)*y(119)*exp(y(32))*params(6)*params(5)*exp(params(5)*y(36))+T(48);
T(117) = (-(exp(y(6))*(-(exp((-y(49)))*exp(y(10))))));
T(118) = T(38)+T(44)+params(25)*y(119)*exp(y(31))*params(6)*params(5)*params(5)*exp(params(5)*y(35));
T(119) = T(33)*y(22)*T(24)*params(6)*params(5)*(params(5)-1)*exp(y(11)*(params(5)-1))+T(33)*y(20)*(-(T(24)*(exp(y(26))*exp(y(11))+y(38)*(-exp(y(11)))-params(6)*params(5)*exp(params(5)*y(11)))));
T(120) = (-(T(23)*(exp(y(36))*exp(y(101))+y(102)*(-exp(y(36)))-params(6)*params(5)*params(5)*exp(params(5)*y(36)))));
T(121) = y(72)*T(120);
T(122) = T(8)*getPowerDeriv(T(8),T(13),2);
T(123) = T(8)*T(122);
T(124) = T(49)+T(123);
T(125) = T(8)*getPowerDeriv(T(8),T(1),2);
T(126) = T(8)*T(125);
T(127) = T(50)+T(126);
T(128) = params(11)*T(127);
T(129) = getPowerDeriv(T(9),T(10),2);
T(130) = exp(y(104))*getPowerDeriv(exp(y(104)),T(1),1);
T(131) = getPowerDeriv(T(63),T(10),2);
T(132) = exp(y(41))*getPowerDeriv(exp(y(41)),T(11),2);
T(133) = exp(y(41))*T(132);
T(134) = T(52)+T(133);
T(135) = y(67)*(-(T(19)*T(16)*T(53)*T(81)+T(5)*T(19)*T(53)*T(83)))+y(66)*(-(T(17)*T(3)*T(54)*T(83)+T(3)*T(16)*T(54)*T(85)));
T(136) = (-(T(5)*T(19)*T(16)*T(52)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(48))));
T(137) = (-(T(17)*T(3)*T(16)*T(52)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(48))));
T(138) = y(67)*T(136)+y(66)*T(137);
T(139) = exp(y(105))*getPowerDeriv(exp(y(105)),T(11),1);
T(140) = (1-params(11))*(1-params(3))*exp(T(1)*y(110))*T(139);
T(141) = (-(T(56)*(T(71)*T(70)*(1-params(11))*params(3)*exp(T(1)*y(110))*T(139)+T(73)*T(68)*(1-params(11))*params(3)*exp(T(1)*y(110))*T(139))));
T(142) = exp(y(13))*getPowerDeriv(exp(y(13)),params(3),1);
T(143) = T(5)*T(142);
T(144) = T(2)*T(87)*T(143);
T(145) = exp(y(13))*getPowerDeriv(exp(y(13)),params(3)-1,1);
T(146) = (-(T(5)*(T(16)*T(53)*T(145)+T(19)*T(53)*T(82)*T(143))));
T(147) = T(16)*T(54)*T(142)+T(3)*T(54)*T(82)*T(143);
T(148) = getPowerDeriv(T(6),T(13),2);
T(149) = T(82)*T(81)*T(142)+T(3)*T(81)*T(143)*T(148);
T(150) = T(15)*T(16)*T(142)+T(3)*T(15)*T(82)*T(143);
T(151) = getPowerDeriv(T(6),T(1),2);
T(152) = T(2)*(T(87)*T(81)*T(142)+T(3)*T(81)*T(143)*T(151));
T(153) = (-(exp(y(43)*(1-params(3)))*T(1)*exp(T(1)*y(48))*params(3)*exp(y(13)*params(3))));
T(154) = T(16)*T(95)*T(145)+T(19)*T(95)*T(82)*T(143);
T(155) = T(16)*T(96)*T(142)+T(3)*T(96)*T(82)*T(143);
T(156) = T(20)*getPowerDeriv(T(20),params(3),2);
T(157) = T(20)*T(156);
T(158) = T(57)+T(157);
T(159) = getPowerDeriv(T(59),T(1),2);
T(160) = T(55)*(T(60)*T(56)*T(158)+T(56)*T(57)*T(56)*T(57)*T(159));
T(161) = getPowerDeriv(T(59),T(13),2);
T(162) = T(69)*T(56)*T(158)+T(56)*T(57)*T(56)*T(57)*T(161);
T(163) = T(20)*getPowerDeriv(T(20),params(3)-1,2);
T(164) = T(20)*T(163);
T(165) = T(73)+T(164);
T(166) = exp(y(14))*getPowerDeriv(exp(y(14)),1+params(8),1);
T(167) = (-(params(9)*T(166)/(1+params(8))));
T(168) = getPowerDeriv(T(27),(-params(14)),1);
T(169) = T(167)*T(168);
T(170) = (-((-(params(1)*T(78)*T(169)))/(T(28)*T(28))));
T(171) = (-((-(params(1)*T(91)*T(169)))/(T(28)*T(28))));
T(172) = T(4)*getPowerDeriv(T(4),1+params(8),2);
T(173) = T(4)*T(172);
T(174) = T(75)+T(173);
T(175) = (-(params(9)*T(174)/(1+params(8))));
T(176) = getPowerDeriv(T(25),(-params(14)),2);
T(177) = T(77)*T(175)+T(76)*T(76)*T(176);
T(178) = T(4)*getPowerDeriv(T(4),1-params(3),2);
T(179) = T(4)*T(178);
T(180) = T(81)+T(179);
T(181) = T(82)*T(3)*T(180)+T(3)*T(81)*T(3)*T(81)*T(148);
T(182) = (-(T(81)*T(19)*T(18)*T(83)+T(16)*T(18)*T(19)*T(180)+T(81)*T(19)*T(18)*T(83)+T(5)*T(19)*T(18)*T(181)));
T(183) = T(4)*getPowerDeriv(T(4),(-params(3)),2);
T(184) = T(4)*T(183);
T(185) = T(85)+T(184);
T(186) = (-(T(3)*T(15)*T(83)*T(85)+T(17)*T(3)*T(15)*T(181)+T(3)*T(15)*T(83)*T(85)+T(3)*T(15)*T(16)*T(185)));
T(187) = T(2)*(T(87)*T(3)*T(180)+T(3)*T(81)*T(3)*T(81)*T(151));
T(188) = T(26)*T(26)*T(26)*T(26);
T(189) = (-((T(26)*T(26)*(-(T(90)*T(177)))-(-(T(78)*T(90)))*(T(26)*T(78)+T(26)*T(78)))/T(188)));
T(190) = exp(y(44))*T(76)*T(176);
T(191) = T(26)*T(26)*(-(T(90)*T(190)))-(-(T(90)*T(91)))*(T(26)*T(78)+T(26)*T(78));
T(192) = (-(T(81)*T(19)*T(16)*T(95)+T(5)*T(19)*T(83)*T(95)));
T(193) = y(67)*T(192);
T(194) = y(66)*(-(T(85)*T(3)*T(16)*T(96)+T(17)*T(3)*T(83)*T(96)));
T(195) = T(3)*T(81)*T(87)*T(97);
T(196) = T(78)*T(101);
T(197) = exp(y(106))*getPowerDeriv(exp(y(106)),1-params(3),1);
T(198) = T(55)*(T(60)*T(57)*T(197)+T(56)*T(57)*T(159)*T(58)*T(197));
T(199) = exp(y(106))*getPowerDeriv(exp(y(106)),(-params(3)),1);
T(200) = T(69)*T(57)*T(197)+T(56)*T(57)*T(161)*T(58)*T(197);
T(201) = exp(y(106))*getPowerDeriv(exp(y(106)),1+params(8),1);
T(202) = (-(params(9)*T(201)/(1+params(8))));
T(203) = getPowerDeriv(T(89),(-params(14)),1);
T(204) = params(1)*T(202)*T(203);
T(205) = (-((-(params(1)*T(78)*exp(y(15))*T(168)))/(T(28)*T(28))));
T(206) = (-((-(params(1)*T(91)*exp(y(15))*T(168)))/(T(28)*T(28))));
T(207) = T(76)*exp(y(44))*T(176);
T(208) = T(26)*T(91)+T(26)*T(91);
T(209) = (-((T(26)*T(26)*(-(T(90)*T(207)))-(-(T(78)*T(90)))*T(208))/T(188)));
T(210) = T(91)+exp(y(44))*exp(y(44))*T(176);
T(211) = exp(y(46))*getPowerDeriv(exp(y(46)),T(22),2);
T(212) = exp(y(46))*T(211);
T(213) = T(93)+T(212);
T(214) = (-(exp(y(43)*(1-params(3)))*exp(y(13)*params(3))*T(1)*T(1)*exp(T(1)*y(48))));
T(215) = (-(T(17)*T(3)*T(16)*T(12)*(1-params(11))*(1-params(3))*T(1)*T(1)*exp(T(1)*y(48))));
T(216) = T(7)*(1-params(11))*T(1)*T(1)*exp(T(1)*y(48));
T(217) = T(56)*T(57)*T(60)*(1-params(11))*T(1)*exp(T(1)*y(110));
T(218) = T(66)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(110));
T(219) = T(57)*T(68)*T(218)+T(58)*T(70)*T(218);
T(220) = T(71)*T(70)*T(66)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(110))+T(73)*T(68)*T(66)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(110));
T(221) = getPowerDeriv(exp(y(63)-y(49)),params(5)-1,2);
T(222) = (-(exp(y(29))*params(6)*(exp(y(63)-y(49))*T(100)+(-exp(y(63)-y(49)))*(-exp(y(63)-y(49)))*T(221))));
T(223) = y(88)*T(115)+y(82)*T(117);
T(224) = (-(exp(y(29))*params(6)*((-exp(y(63)-y(49)))*T(100)+exp(y(63)-y(49))*(-exp(y(63)-y(49)))*T(221))));
T(225) = params(25)*y(123)*(-(exp(y(31))*(-(exp(y(35))*(-exp((-y(111))))))))+params(25)*y(129)*(-(exp(y(31))*exp(y(35))*(-exp((-y(111))))));
T(226) = y(87)*T(108)+y(81)*T(109)+y(69)*exp(y(17))*params(22)*params(21)*exp(params(21)*y(54));
T(227) = T(33)*y(23)*(-(T(24)*(exp(y(26))*exp(y(54))+y(55)*(-exp(y(54)))-params(22)*params(21)*params(21)*exp(params(21)*y(54)))));
T(228) = T(33)*y(23)*(-(T(24)*(-exp(y(54)))));
T(229) = params(25)*y(128)*(-(exp(y(112))*exp(y(52))))+params(25)*y(119)*exp(y(52))*params(22)*params(21)*exp(params(21)*y(112))+params(25)*y(122)*(-(exp(y(52))*(-exp(y(112)))));
T(230) = (-exp(y(63)-y(49)))*T(100)+(-exp(y(63)-y(49)))*exp(y(63)-y(49))*T(221);
T(231) = (-(exp(y(29))*params(6)*T(230)));
T(232) = (-(exp(y(29))*params(6)*(exp(y(63)-y(49))*T(100)+exp(y(63)-y(49))*exp(y(63)-y(49))*T(221))));
T(233) = T(33)*(-(T(24)*exp(y(26))*exp(y(54))));
T(234) = T(33)*(-(T(24)*(exp(y(26))*exp(y(54))+y(55)*(-exp(y(54)))-params(22)*params(21)*exp(params(21)*y(54)))));
T(235) = params(25)*(-(exp(y(31))*(-(exp((-y(111)))*exp(y(35))))));
T(236) = params(25)*(-(exp(y(31))*exp((-y(111)))*exp(y(35))));

end
